/*******************************************************
Filename		:  	DW_result_download_custom.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1446, 1500, 1502, 1503, 1564, 1558, 1561
Description		:  	Creates a report in the form of a text file that contains the 
				columns the user has requested.
Author			:  	Joseph Wilson
Date			: 	March 4, 2003 --changed var table type to vc_arr
				March 25, 2003 --updated date formatting and colum names
				April 7, 2003 --added long char report fields
				April 18, 2003 --added Visit Stop and Visit Start report fields
				June 27, 2003 --pass HINT for report creation
				July 2, 2003 --made compatible with data element groups and dynamic element lists
				July 3, 2003 --updated date formatting to use date/time combo fields -JW
				July 7, 2003 --added sorting of columns within data element groups, updated table alias -JW
				July 10, 2003 --added analytical_procedure_source to analytical_procedure_id -JW
				July 22, 2003 --added support for the Biological and Habitat reports -JW
				August 22, 2003 -- changed report file extention to txt -JW
				October 7, 2003 -- added blob URLs to reports -JW
				October 29, 2003 -- added new file prefixes based on report type (SIR 1564) -JW
				October 30, 2003 -- added activity blob URLs to reports -JW
                        November 5, 2003 -- updated to separate time zone from date/time columns (SIR 1561) -CT
Comments		:  	Uses the table APP_COLUMN_NAME to create the column titles. Dynamic SQL
				is used so only the requested columns and corresponding tables are included
				in the query.  --added long col table
**********************************************************/

CREATE OR REPLACE PROCEDURE DW_result_download_custom 
(v_FromStmt			IN	VARCHAR2,
v_WhereStmt			IN	VARCHAR2,
v_rule_optimization		IN	VARCHAR2,
v_report_type			IN	CHAR default 'REGULAR',
v_Columns			IN	owa_util.vc_arr,
--v_ActColumns			IN	owa_util.ident_arr,
filename                	IN	varchar2,
out_file			OUT	varchar2
) AS
--The out_file variable, the output of this routine, contains the entire URL of
--the file created herein.
-- File handler while creating a file using utl_file package.
my_out_file			UTL_FILE.FILE_TYPE;
--
--Name of downloadable file that will be created on the server.  This
--file name will be generated based on the current date and time.
out_file_name			VARCHAR2(30);
iodir         			VARCHAR2(100);
download_path 			VARCHAR2(100);
lv_rows       			NUMBER;

v_pk_isn			NUMBER(12);
v_Dummy				INTEGER;
v_CursorID			INTEGER;
v_SQLStmt			VARCHAR2(32000);
v_SelectStmt			VARCHAR2(32000);
v_ReturnRow   			VARCHAR2(32000);
--v_ReturnRow2   		VARCHAR2(32000);
v_Print_Name			VARCHAR2(40);
v_Print_Names_List		VARCHAR2(30000);
v_FromStmtNew 			VARCHAR2(4000);
v_WhereStmtNew 			VARCHAR2(4000);
v_CurrentColumn   		VARCHAR2(200);

--flags used to ensure a table is not included twice in the FROM clause
--f_LU_STATN_TYPES 		BOOLEAN := FALSE;
f_LU_GEO_STATE 			BOOLEAN := FALSE;
f_DI_ACTIVITY			BOOLEAN := FALSE;
f_LU_RESULT_LONG		BOOLEAN := FALSE;

v_report_number	number;

CURSOR c_ReportColumn IS
	SELECT print_name,col_name
		FROM APP_COLUMN_NAME
		WHERE reg_report_number = v_report_number
		ORDER BY REG_COL_ORDER;

CURSOR c_BIOReportColumn IS
	SELECT print_name,col_name
		FROM APP_COLUMN_NAME
		WHERE bio_report_number = v_report_number
		ORDER BY bio_COL_ORDER;

CURSOR c_HABReportColumn IS
	SELECT print_name,col_name
		FROM APP_COLUMN_NAME
		WHERE hab_report_number = v_report_number
		ORDER BY hab_COL_ORDER;

BEGIN
rollback;

v_SelectStmt := 'SELECT ';
IF v_rule_optimization = 'TRUE' THEN
	v_SelectStmt := 'SELECT /*+ RULE*/ ';
END IF;
v_FromStmtNew := v_FromStmt;
v_WhereStmtNew := v_WhereStmt;
--include appropriate tables in FROM clause based on columns selected
IF v_report_type = 'BIOLOGICAL' THEN
	FOR i IN 1 .. v_Columns.LAST LOOP
		v_report_number := TO_NUMBER(v_Columns(i));
		FOR ReportColumn in c_BIOReportColumn LOOP

    		v_CurrentColumn := ReportColumn.col_name;
		v_print_names_list := v_print_names_list||ReportColumn.print_name||'~';

		IF ReportColumn.col_name = 'HORIZONTAL_DATUM' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
			IF f_LU_GEO_STATE = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
				v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
				f_LU_GEO_STATE := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name= 'COUNTY_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
		END IF;

    		IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
		END IF;

		IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		END IF;

		IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
		  v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||''-''||ANALYTICAL_PROCEDURE_ID';
		END IF;
		IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
		END IF;
		IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
		END IF;

		v_SelectStmt := v_SelectStmt ||v_CurrentColumn||'||''~''||';
		END LOOP;
	END LOOP;

ELSIF v_report_type = 'HABITAT' THEN
	FOR i IN 1 .. v_Columns.LAST LOOP
		v_report_number := TO_NUMBER(v_Columns(i));
		FOR ReportColumn in c_HABReportColumn LOOP

    		v_CurrentColumn := ReportColumn.col_name;
		v_print_names_list := v_print_names_list||ReportColumn.print_name||'~';

		IF ReportColumn.col_name = 'HORIZONTAL_DATUM' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
			IF f_LU_GEO_STATE = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
				v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
				f_LU_GEO_STATE := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name= 'COUNTY_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
		END IF;

    		IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
		END IF;

		IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		END IF;

		IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
		  v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||''-''||ANALYTICAL_PROCEDURE_ID';
		END IF;
		IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
		END IF;
		IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
		END IF;

		v_SelectStmt := v_SelectStmt ||v_CurrentColumn||'||''~''||';
		END LOOP;
	END LOOP;

ELSE 
	FOR i IN 1 .. v_Columns.LAST LOOP
		v_report_number := TO_NUMBER(v_Columns(i));
		FOR ReportColumn in c_ReportColumn LOOP

    		v_CurrentColumn := ReportColumn.col_name;
		v_print_names_list := v_print_names_list||ReportColumn.print_name||'~';

		IF ReportColumn.col_name = 'HORIZONTAL_DATUM' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HDATUM hd';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hdatum = hd.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'GEOPOSITIONING_METHOD' THEN
			v_FromStmtNew := v_FromStmtNew||',LU_MAD_HMETHOD hm';
			v_WhereStmtNew := v_WhereStmtNew||' AND fk_act_mad_hmethod = hm.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'ORGANIZATION_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_ORG og';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_org = og.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'STATE_NAME' OR v_Columns(i) = 'COUNTRY_NAME' THEN
			IF f_LU_GEO_STATE = FALSE THEN
				v_FromStmtNew := v_FromStmtNew||',DI_GEO_STATE gs';
				v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_state = gs.pk_isn (+)';
				f_LU_GEO_STATE := TRUE;
			END IF;
		END IF;
		IF ReportColumn.col_name= 'COUNTY_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_GEO_COUNTY gc';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_geo_county = gc.pk_isn (+)';
		END IF;
		IF ReportColumn.col_name= 'HYDROLOGIC_UNIT_NAME' THEN
			v_FromStmtNew := v_FromStmtNew||',DI_DB_CAT ca';
			v_WhereStmtNew := v_WhereStmtNew||' AND FA.fk_db_cat = ca.pk_isn (+)';
		END IF;

    		IF ReportColumn.col_name= 'FA.ACTIVITY_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_STOP_TIME,''HH24:MI:SS'')||'' ''||ACT_STOP_TIME_ZONE';
		END IF;

		IF ReportColumn.col_name= 'FA.ACTIVITY_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(ACTIVITY_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(ACTIVITY_START_TIME,''HH24:MI:SS'')||'' ''||ACT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYSIS_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(ANALYSIS_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		END IF;

		IF ReportColumn.col_name= 'FA.VISIT_START_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_START_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_START_TIME,''HH24:MI:SS'')||'' ''||VISIT_START_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.VISIT_STOP_DATE_TIME' THEN
		  v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE_TIME,''YYYY-MM-DD HH24:MI:SS'')';
		  --v_CurrentColumn := 'TO_CHAR(VISIT_STOP_DATE,''MM-DD-YYYY'')||'' ''||TO_CHAR(VISIT_STOP_TIME,''HH24:MI:SS'')||'' ''||VISIT_STOP_TIME_ZONE';
		END IF;
		IF ReportColumn.col_name= 'FA.ANALYTICAL_PROCEDURE_SOURCE' THEN
		  v_CurrentColumn := 'ANALYTICAL_PROCEDURE_SOURCE||''-''||ANALYTICAL_PROCEDURE_ID';
		END IF;
		IF ReportColumn.col_name= 'FA.BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.BLOB_ID)';
		END IF;
		IF ReportColumn.col_name= 'FA.ACT_BLOB_ID' THEN
			v_CurrentColumn := 'DECODE(FA.ACT_BLOB_ID, NULL, NULL,'''||dw_glob_var.lv_program_path||'DW_blob_download?v_blob_id=''||FA.ACT_BLOB_ID)';
		END IF;

		v_SelectStmt := v_SelectStmt ||v_CurrentColumn||'||''~''||';
		END LOOP;
	END LOOP;
END IF;
v_SelectStmt := RTRIM(v_SelectStmt,'||''~''||');

v_print_names_list := RTRIM(v_print_names_list,'||''~''||');

--v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew||' AND location_point_type = ''*POINT OF RECORD''';
v_SQLStmt := v_SelectStmt||' '||v_FromStmtNew||' '||v_WhereStmtNew;

--htp.print('<BR>'||v_sqlstmt||'<BR>');

v_CursorID := DBMS_SQL.OPEN_CURSOR;
DBMS_SQL.PARSE(v_CursorID, v_SQLStmt, DBMS_SQL.NATIVE);
/**
DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_pk_isn, 12);
DBMS_SQL.DEFINE_COLUMN(v_CursorID, 2, v_ReturnRow, 32000);
--DBMS_SQL.DEFINE_COLUMN(v_CursorID, 3, v_ReturnRow2, 32000);
**/
DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);

v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

--checking to see if a filename is passed
if (filename <> 'NONE') then
	out_file_name := filename;
else
	-- Generating a unique name for creating a file on the server.
	out_file_name := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS');
	--out_file_name := 'SDS'||out_file_name||'.txt' ;
	IF v_report_type = 'BIOLOGICAL' THEN
		out_file_name := 'SDB'||out_file_name||'.txt' ;
	ELSIF v_report_type = 'HABITAT' THEN
		out_file_name := 'SDH'||out_file_name||'.txt' ;
	ELSE
		out_file_name := 'SDR'||out_file_name||'.txt' ;
	END IF;

end if;
--
-- File handler used by utl_file package.
--
iodir := DW_GLOB_VAR.LV_IODIR;
download_path := DW_GLOB_VAR.LV_DOWNLOAD_PATH;

--my_out_file := UTL_FILE.FOPEN(iodir,out_file_name,'W');
my_out_file := UTL_FILE.FOPEN(iodir,out_file_name,'W',30000);
--
-- out_file is an out parameter.  It holds URL of the downloadable file that
-- will be created by this procedure.
out_file:=download_path||out_file_name;
UTL_FILE.PUT_LINE(my_out_file,v_print_names_list);

LOOP
	IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
		EXIT;
	END IF;
	DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
	--DBMS_SQL.COLUMN_VALUE(v_CursorID, 2, v_ReturnRow);
	--DBMS_SQL.COLUMN_VALUE(v_CursorID, 3, v_ReturnRow2);
	--UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow||'~'||v_ReturnRow2);
	UTL_FILE.PUT_LINE(my_out_file,v_ReturnRow);
END LOOP;

DBMS_SQL.CLOSE_CURSOR(v_CursorID);
UTL_FILE.FCLOSE(my_out_file);

EXCEPTION
  WHEN UTL_FILE.INVALID_PATH THEN DBMS_OUTPUT.PUT_LINE ('INVALID PATH');
  commit;
  WHEN UTL_FILE.INVALID_MODE THEN DBMS_OUTPUT.PUT_LINE ('INVALID MODE');
  commit;
  WHEN UTL_FILE.INVALID_FILEHANDLE THEN
  commit;
    DBMS_OUTPUT.PUT_LINE ('INVALID FILEHANDLE');
  WHEN UTL_FILE.INVALID_OPERATION THEN
    DBMS_OUTPUT.PUT_LINE ('INVALID OPERATION');
  commit;
  WHEN UTL_FILE.READ_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD READ');
  commit;
  WHEN UTL_FILE.WRITE_ERROR THEN DBMS_OUTPUT.PUT_LINE ('BAD WRITE');
  commit;
  WHEN UTL_FILE.INTERNAL_ERROR THEN DBMS_OUTPUT.PUT_LINE ('INTERNAL');
  commit;
END;
/
SHOW ERRORS